package unipotsdam.informatikkiste;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;

/**
 * An event, that displays a text and the given date-String as "date of last solve" in a new activity
 * Created by Robin Engel on 23.06.2017.
 */

public class DisplayAnswerEvent implements AnswerEvent {

    private int riddleId;
    private String displayText;
    private String displayDate;

    public DisplayAnswerEvent(String text, String date, int riddleId){
        this.riddleId = riddleId;
        this.displayText = text;
        this.displayDate = date;
    }

    @Override
    public void fireEvent(MainActivity context) {
        context.riddleIdView.setBackgroundColor(context.getResources().getColor(R.color.colorSolved));
        final Handler handler = new Handler();
        handler.postDelayed(new StartSequence(context), context.getResources().getInteger(R.integer.response_time));
    }

    private class StartSequence implements Runnable{

        MainActivity context;

        public StartSequence(MainActivity context){
            this.context = context;
        }

        @Override
        public void run() {
            Intent intent = new Intent(context, DisplayAnswerActivity.class);
            Bundle data = new Bundle();
            data.putInt("riddleId",riddleId);
            data.putString("message",displayText);
            data.putString("date",displayDate);
            intent.putExtras(data);
            context.startActivity(intent);
            context.riddleIdView.resetBackgroundColor();
        }
    }
}
